<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package totara
 * @subpackage cohort
 */

$string['abouttocreate'] = 'You are about to create a new audience called "{$a}"';
$string['actions'] = 'Actions';
$string['addcertifications'] = 'Add certifications';
$string['addcohort'] = 'Create New Audience';
$string['addcourses'] = 'Add courses';
$string['addenrolledlearning'] = 'Add enrolled learning items';
$string['addnewmembers']  = 'Make a user a member when they meet rule sets criteria';
$string['addprograms'] = 'Add programs';
$string['addremovehelp']  = 'Add or remove users';
$string['addremovehelp_help'] = 'You can use these options to control when a user should be added to, or removed from,
audience membership.

Unselecting both options will freeze membership until either (or both) of the options are changed.';
$string['addremovelabel']  = 'Automatically update membership ';
$string['addrule'] = 'Add rule';
$string['addruleset'] = 'Add a Rule Set';
$string['addvisiblelearning'] = 'Add visible learning';
$string['alertmembers'] = 'Alerts';
$string['alertmembers_help'] = '**Do not send alerts -**
Alerts will not be sent to members when they are added or removed from this group.

**Send alerts to affected members only -**
If selected, notifications will be sent to members when they are added to the audience, or when they are removed.

**Send alerts to all members -**
As above, but for all members.';
$string['alertmembersaffected'] = 'Send alerts to affected members only';
$string['alertmembersall'] = 'Send alerts to all members';
$string['alertmembersnone'] = 'Do not send alerts';
$string['and'] = 'AND';
$string['andcohort'] = 'AND...';
$string['anycohort'] = 'Any';
$string['approvechanges'] = 'Approve changes';
$string['assign'] = 'Assign';
$string['assignenrolledlearningcourse'] = 'Add Courses to Enrolled Learning';
$string['assignenrolledlearningprogram'] = 'Add Programs to Enrolled Learning';
$string['assignenrolledlearningcertification'] = 'Add Certifications to Enrolled Learning';
$string['assignmemberstocohort'] = 'Assign members to audience';
$string['assignroles'] = 'Assign Roles';
$string['assignto'] = 'Audience \'{$a}\' members';
$string['assignvisiblelearningcourse'] = 'Add Courses to Visible Learning';
$string['assignvisiblelearningprogram'] = 'Add Programs to Visible Learning';
$string['assignvisiblelearningcertification'] = 'Add Certifications to Visible Learning';
$string['associationcertificationsonly'] = 'Show certifications only';
$string['associationprogramsonly'] = 'Show programs only';
$string['associationactionsenrolled'] = 'Actions';
$string['associationactionsvisible'] = 'Actions';
$string['associationcoursesonly'] = 'Show courses only';
$string['associationenrolled'] = 'Enrolled';
$string['associationname'] = 'Name';
$string['associationnameiconlink'] = 'Name (with icon and link)';
$string['associationprogramcompletionlink'] = 'Completion';
$string['associationtype'] = 'Type';
$string['audiencevisibility'] = 'Audience-based visibility';
$string['autocreatenew'] = 'Dynamic creation';
$string['autocreatenew_help'] = 'Based on these settings, automatically create a new learning plan for every new user who becomes a member of this audience.

If the \'exclude users who\' setting for \'have an existing, automatically created plan based on this template\' is not set, automatic creation of learning plans will not be available.

If a user is removed from the audience any created learning plans will remain';
$string['autocreatenewon'] = 'New learning plans will be automatically generated for every new user who becomes a member of this audience.';
$string['autocreatenewoff'] = 'Learning plans will not be automatically generated for users who become a member of this audience in the future.';
$string['autocreateplan'] = 'Automatically create plans';
$string['autocreateplan_help'] = 'Automatically create learning plans for members of this Audience using the selected plan template';
$string['backtocohorts'] = 'Back to audiences';
$string['cancel'] = 'Cancel';
$string['cancelchanges'] = 'Cancel changes';
$string['cannoteditcohort'] = 'This audience can not be edited once created';
$string['categorycohorts'] = 'Category audiences';
$string['ccdatedescafter'] = 'User completed this list of courses after {$a}:';
$string['ccdatedescbefore'] = 'User completed this list of courses before {$a}:';
$string['ccdescall'] = 'User has completed all of the courses in this list:';
$string['ccdescany'] = 'User has completed any of the courses in this list:';
$string['ccdescnotall'] = 'User has not completed all of the courses in this list:';
$string['ccdescnotany'] = 'User has not completed any of the courses in this list:';
$string['ccdurationdesclessthan'] = 'User completed this list of courses in less than {$a} day(s):';
$string['ccdurationdescmorethan'] = 'User completed this list of courses in greater than {$a} day(s):';
$string['checkboxno'] = 'Unchecked';
$string['checkboxyes'] = 'Checked';
$string['childrenincluded'] = 'children included';
$string['choose'] = 'Choose';
$string['choosecohorts'] = 'Choose audiences';
$string['chooseitem'] = 'Choose item';
$string['chooseplantemplate'] = 'Choose template';
$string['cleanuptask'] = 'Cleanup cohort assign roles';
$string['clear'] = 'Clear';
$string['clonecohort'] = 'Clone audience';
$string['cloneconfirm'] = 'Do you really want to create a copy of the audience \'{$a}\'?';
$string['clonename'] = 'Copy of {$a}';
$string['clonethiscohort'] = 'Clone this audience';
$string['cohort'] = 'Audience';
$string['cohort:assign'] = 'Assign audience members';
$string['cohort:manage'] = 'Manage audiences';
$string['cohort:managerules'] = 'Manage dynamic audience rules';
$string['cohort:view'] = 'Use audiences and view members';
$string['cohort_associations'] = 'Audience associated learning';
$string['cohort_associations_visible'] = 'Audience associated visible learning';
$string['cohortadminreportname'] = 'Audience Admin Screen';
$string['cohortalertoptions'] = 'Alert options';
$string['cohortalertoptions_help'] = '
**Audiences alert settings** allows a user with the appropriate permissions to specify the alert options that are available to users on the Audience edit page. This setting affects all **Audience** edit pages.

When multiple options are selected the user can choose their preferred options from the alert dropdown menu.

When no options are selected, the alert function is disabled.';
$string['cohortapplyinbackground'] = 'Apply dynamic audience membership changes in background';
$string['cohortapplyinbackground_help'] = 'Dynamic audience membership needs to be updated after audience rule changes are approved, which can take some time to complete. When checked, updates will be scheduled to occur as a background task. If unchecked, updates will occur immediately which will require the user who is approving the changes to wait for the update to complete.';
$string['cohortbrokenrule'] = '{$a->type} - {$a->name} => This rule is broken';
$string['cohortbrokenruleemail'] = '{$a->ruleset} - {$a->type} - {$a->name} => This rule is broken';
$string['cohortbrokenrulesmessage'] = 'Some broken rules have been found.
While there are broken rules the audience membership will not be updated.

The following dynamic audience needs your attention:

';
$string['cohortbrokenrulesnotice'] = 'Some broken rules have been found. While there are broken rules the audience membership will not be updated';
$string['cohortbrokenrulesubject'] = 'Some broken rules have been found';
$string['cohortbugheading'] = 'There was a bug in Totara 2.4.8 - 2.4.12 which may have affected your
site. <a href="https://totara.community/mod/forum/discuss.php?d=3407" target="_blank">More information about this issue.</a>';
$string['cohortbugfixingxrules'] = 'The system has been able to fix {$a} audience rule(s) automatically.';
$string['cohortbugnounfixable'] = 'All the detected issues were able to be fixed. No more action is required.';
$string['cohortbugneedfixing'] = 'The system has determined that the following rules may have been affected, but is unable to fix them automatically. Once the upgrade is complete, please review these
rules and verify they are correct.';
$string['cohortdateactive'] = 'Active';
$string['cohortdatealreadyended'] = 'Already ended';
$string['cohortdatenotyetstarted'] = 'Not yet started';
$string['cohortenrolledlearningselect'] = 'To view enrolled learning, first <a href="{$a}">select an audience</a> then click the "Enrolled Learning" tab.';
$string['cohortenrolledreportname'] = 'Audience: Enrolled Learning';
$string['cohortglobalsettings'] = 'Audience global settings';
$string['cohortmembers'] = 'Audience members';
$string['cohortmembersselect'] = 'To view audience members, first <a href="{$a}">select an audience</a> then click the "View Members" tab.';
$string['cohortmsgalreadyended'] = 'This audience is inactive, because its <strong>end date</strong> is in the past: <strong>{$a}</strong>. No users will be enrolled in any learning items while this audience is inactive, and any existing enrolments due to this audience will be unenrolled.';
$string['cohortmsgnotyetstarted'] = 'This audience is inactive, because its <strong>start date</strong> is in the future: <strong>{$a}</strong>. No users will be enrolled in any learning items while this audience is inactive, and any existing enrolments due to this audience will be unenrolled.';
$string['cohortmsgalreadyendedlimited'] = 'This audience is inactive, because its <strong>end date</strong> is in the past: <strong>{$a}</strong>. This means that dashboards granted access by this audience will be unavailable, and if this is a dynamic audience, it will not be automatically updated.';
$string['cohortmsgnotyetstartedlimited'] = 'This audience is inactive, because its <strong>start date</strong> is in the future: <strong>{$a}</strong>. This means that dashboards granted access by this audience will be unavailable, and if this is a dynamic audience, it will not be automatically updated.';
$string['cohortname'] = 'Audience name';
$string['cohortoperatorandlabel'] = 'AND (members are in every rule set)';
$string['cohortoperatorlabel'] = 'Membership setting between every rule set';
$string['cohortoperatorlabel_help'] = 'This setting determines how the audience rules will behave if you define more than one rule set. It is based on the logical "AND" and "OR" operators.

* If set to "AND", then a user will only be added to the audience if they satisfy the conditions of <strong>all</strong> of the rule sets. (They will be omitted if they fail to satisfy even one ruleset)
* If set to "OR", then a user will be added to the audience if they satisfy the conditions of <strong>any</strong> of the rule sets. (They only have to satisfy the conditions of a single rule set to be included)

Note that each ruleset has its own, separate, logical operator to indicate the relationship between the rules within that ruleset.';
$string['cohortoperatororlabel'] = 'OR (members are in any rule set)';
$string['cohortruleschanged'] = 'Audience rules changed';
$string['cohortruleschangednote'] = 'Audience membership will be updated immediately after approval, this may take a while.';
$string['cohortruleschangedadhocnote'] = 'Audience membership update will be scheduled for later.';
$string['cohorts'] = 'Audiences';
$string['cohortsaddenrolled'] = 'Add enrolled audiences';
$string['cohortsaddvisible'] = 'Add visible audiences';
$string['cohortsin'] = 'Available Audiences';
$string['cohortvisiblelearningselect'] = 'To view visible learning, first <a href="{$a}">select an audience</a> then click the "Visible Learning" tab.';
$string['cohortvisiblereportname'] = 'Audience: Visible Learning';
$string['complete'] = 'Complete';
$string['completioncriteria'] = 'Completion criteria';
$string['completiondurationdays'] = 'day(s)';
$string['completiondurationmenulessthan'] = 'less than';
$string['completiondurationmenumorethan'] = 'more than';
$string['completionmenuall'] = 'has completed all';
$string['completionmenuany'] = 'has completed any';
$string['completionmenunotall'] = 'has NOT completed all';
$string['completionmenunotany'] = 'has NOT completed any';
$string['completionusercompletedbeforeafter'] = 'User completed:';
$string['component'] = 'Source';
$string['configaudiencevisibility'] = 'Default visibility option when the site-wide audience-based visibility setting is enabled';
$string['configenableaudiencevisibility'] = 'When enabled, course, program and certification visibility will switch to a more advanced interface which supports assigning "Visible learning" to Audiences at a site-wide level.

Once enabled, the visibility of each individual course, program or certification can be set to "Visible to all users", "Visible to enrolled users" or "Visible to enrolled users and members of the selected audiences". If "Visible to enrolled users and members of the selected audiences" is selected then the course, program or certification is only visible to enrolled users and members of any of the assigned audiences.

<strong>Warning:</strong> Enabling this setting will change the visibility of courses, programs and certifications across the whole site - the existing "Visibility" setting and the "viewhiddencourses" capability will no longer apply, so courses, programs and certifications that are currently hidden may become visible.';
$string['confirmcreateplansmessage'] = 'This will create new learning plans for {$a} user(s).';
$string['confirmdynamiccohortcreation'] = 'Confirm Dynamic Audience Creation';
$string['confirmnousers'] = 'No users require having learning plans created.';
$string['contains'] = 'contains';
$string['continue'] = 'Do you want to continue?';
$string['copy'] = 'Copy';
$string['coursecohortsenrolled'] = 'Course audiences (enrolled)';
$string['coursecohortsvisible'] = 'Course audiences (visible)';
$string['createdynamiccohort'] = 'Create dynamic audience';
$string['createforexistingautoplan'] = 'have an existing, automatically created plan based on this template';
$string['createforexistingcompleteplan'] = 'have a completed plan based on this template';
$string['createforexistingmanualplan'] = 'have an existing, manually created plan based on this template';
$string['createlpforaudience'] = 'Create learning plans for users in this audience';
$string['createlpforaudienceblurb'] = 'This page allows you to automatically create learning plans for all users currently assigned to this audience.';
$string['createnewcohort'] = 'Create new audience';
$string['createplans'] = 'Create plans';
$string['createplansfornewmembers'] = 'Automatically create a new learning plan for every new user who becomes a member of this audience';
$string['createplanstatus'] = 'Create new plans as';
$string['createplanstatus_help'] = 'This will be the status that the created plans are given';
$string['criteria'] = 'Criteria';
$string['criteriaoptional'] = 'All criteria are optional but you have to select at least one option.';
$string['currentusers'] = 'Current users';
$string['currentusersmatching'] = 'Current users matching';
$string['dateformathint'] = '&nbsp;<strong>Format:</strong> dd/mm/yy';
$string['dateformatlongyearhint'] = '&nbsp;<strong>Format:</strong> {$a}';
$string['dateisafter'] = 'is on and after {$a}';
$string['dateisafterfutureduration'] = 'is more than {$a} day(s) in the future';
$string['dateisbefore'] = ' is before {$a}';
$string['dateisbeforepastduration'] = 'is more than {$a} day(s) ago';
$string['dateisinfutureduration'] = 'is within the upcoming {$a} day(s)';
$string['dateisinnextxdays'] = 'is in the next {$a} day(s)';
$string['dateisinpastduration'] = 'is within the past {$a} day(s)';
$string['datemenubeforepastduration'] = 'Delete audience';
$string['datemenudurationafterfuture'] = 'after the upcoming';
$string['datemenudurationbeforepast'] = 'before previous';
$string['datemenudurationwithinfuture'] = 'within the upcoming';
$string['datemenudurationwithinpast'] = 'within the previous';
$string['datemenufixeddateafter'] = 'after';
$string['datemenufixeddateafterandon'] = 'on and after';
$string['datemenufixeddatebefore'] = 'before';
$string['datemenufixeddatebeforeandon'] = 'before and on';
$string['delcohort'] = 'Delete audience';
$string['delconfirm'] = 'Do you really want to delete audience \'{$a}\'?';
$string['deletelearningconfirm'] = 'Are you sure you want to delete this learning item?';
$string['deletelearningitem'] = 'Delete';
$string['deleterule'] = 'Delete rule';
$string['deleteruleconfirm'] = 'Are you sure you want to delete this rule?';
$string['deleteruleparam'] = 'Delete rule item';
$string['deleteruleparamconfirm'] = 'Are you sure you want to delete this rule item?';
$string['deletethiscohort'] = 'Delete this audience';
$string['directreportsno'] = 'Does not have direct reports';
$string['directreportsyes'] = 'Has direct reports';
$string['doesnotcontain'] = 'does not contain';
$string['duplicateidnumber'] = 'Audience with the same ID number already exists';
$string['durationdays'] = 'day(s)';
$string['dynamic'] = 'Dynamic';
$string['dynamiccohortcriteria'] = 'Dynamic Audience Criteria';
$string['dynamiccohortcriterialower'] = 'Dynamic audience criteria';
$string['editcohort'] = 'Edit audience';
$string['editdetails'] = 'Edit details';
$string['editmembers'] = 'Edit members';
$string['editrule'] = 'Edit rule';
$string['editrules'] = 'Rule sets';
$string['enableaudiencevisibility'] = 'Enable audience-based visibility';
$string['enddate'] = 'End date';
$string['enddate_help'] = 'If an end date is provided, the audience will be treated as empty after the end date.'; // Unused.
$string['enddatelimited'] = 'End date';
$string['enddatelimited_help'] = 'If an end date is provided:

* access to dashboards granted by this audience will not be available after this date
* if this is a dynamic audience, audience members will not be automatically updated after this date

';
$string['endswith'] = 'ends with';
$string['enrolledcohorts'] = 'Enrolled audiences';
$string['enrolledlearning'] = 'Enrolled learning';
$string['entervaliddate'] = 'Enter a valid date';
$string['equalto'] = 'Equal to';
$string['error:badcohortid'] = 'Audience with this id does not exist';
$string['error:baddate'] = 'Please specify a valid date';
$string['error:baddateoption'] = 'You must select an option';
$string['error:badduration'] = 'Please specify a valid number of days';
$string['error:badresponsefromajax'] = 'Error: erroneous response from Ajax';
$string['error:badrule'] = 'No rule definition found for {$a}';
$string['error:badruleonupgrade'] = 'Dynamic Audience "{$a}" contains criteria based on a user profile customfield of type textarea. This type of criteria is no longer supported in Totara 2.2 Audiences. You should check the rules for the "{$a}" Audience after the upgrade and make any necessary changes.';
$string['error:capabilitycohortview'] = 'You do not have the necessary permissions to view audiences';
$string['error:couldnotapprovechanges'] = 'Error while approving changes';
$string['error:couldnotcancelchanges'] = 'Error while cancelling changes';
$string['error:couldnotupdateglobalsettings'] = 'There was an error while updating the global settings';
$string['error:couldnotupdatemembershipoption'] = 'There was an error while updating the membership option';
$string['error:dateformat'] = 'Please enter a date in the format {$a}';
$string['error:mustpickonevalue'] = 'You must specify at least one value';
$string['error:noeditdynamiccohort'] = 'This is a dynamic audience. You cannot directly edit its members.';
$string['error:noresponsefromajax'] = 'Error: No response from Ajax';
$string['error:notdynamiccohort'] = 'This is not a dynamic audience.';
$string['error:notenoughvisibility'] = 'You are not allowed to view this content.';
$string['error:novisibleaudiencesselected'] = 'Audiences must be added when using the option "Visible to enrolled users and members of the selected audiences" is selected';
$string['error:rulemissing'] = 'A required parameter (rule) was missing';
$string['error:rulemissingparams'] = 'This rule is not defined.';
$string['error:startafterfinish'] = 'Start date must not be later than finish date';
$string['error:unknownbuttonclicked'] = 'Unknown button clicked';
$string['error:visiblelearningdisabled'] = 'Visible learning is not enabled.';
$string['eventcertificationitemadded'] = 'Certification item added';
$string['eventcertificationitemdeleted'] = 'Certification item deleted';
$string['eventcohortoperatorupdated'] = 'Cohort operator updated';
$string['eventcohortmembershipoptionsupdated'] = 'Cohort membership options updated';
$string['eventcourseitemadded'] = 'Course item added';
$string['eventcourseitemdeleted'] = 'Course item deleted';
$string['eventdraftdiscarded'] = 'Draft discarded';
$string['eventdraftsaved'] = 'Draft saved';
$string['eventlearningitemadded'] = 'Visible learning item added';
$string['eventlearningitemdeleted'] = 'Visible learning item deleted';
$string['eventprogramitemadded'] = 'Program item added';
$string['eventprogramitemdeleted'] = 'Program item deleted';
$string['eventrulecreated'] = 'Rule created';
$string['eventruledeleted'] = 'Rule deleted';
$string['eventruleparamdeleted'] = 'Rule param deleted';
$string['eventrulesetcreated'] = 'Ruleset created';
$string['eventrulesetdeleted'] = 'Ruleset deleted';
$string['eventrulesetoperatorupdated'] = 'Ruleset operator updated';
$string['eventruleupdated'] = 'Rule updated';
$string['error:typecompletion'] = 'Rule definition type is incorrect';
$string['excludeuserswho'] = 'Exclude users who';
$string['excludeuserswho_help'] = 'This setting lets you choose types of users to exclude from having plans generated for them

**having an existing, manually created plan based on this template** <br />
If a user has a plan based on this template that was manually created by them or their manager then they will not get a new plan created.

**having an existing, automatically created plan based on this template** <br />
If a user has an automatically created plan based on this template then they will not get a new plan created.

**have a completed plan based on this template** <br />
If this option is selected then users who have a completed plans based on this template will not have a new template created.';
$string['failedtoclone'] = 'Failed to clone audience';
$string['failedtodeleted'] = 'Failed to delete audience';
$string['globalsettings'] = 'Global settings';
$string['globalsettingsupdated'] = 'Global settings updated';
$string['history'] = 'History';
$string['idnumber'] = 'Id';
$string['includechildren'] = 'Include children';
$string['includechildrenno'] = 'Don\'t include children';
$string['includechildrenyes'] = 'Include children';
$string['incohort'] = 'In audience(s)';
$string['instructions:assignmentroles'] = 'When selecting a role, all members of this audience will be assigned to it in the system context.';
$string['isempty'] = 'is empty';
$string['isequalto'] = 'is equal to';
$string['isnotequalto'] = 'is not equal to';
$string['learningitemcourses'] = 'Courses';
$string['learningitemprograms'] = 'Programs';
$string['learningplan'] = 'Learning Plan';
$string['manageaudincevisibility'] = 'Manage audience-based visibility';
$string['members'] = 'Members';
$string['memberscount'] = 'Size';
$string['membersupdated'] = 'Members updated';
$string['menucohortsvisible'] = 'Menu item audiences';
$string['msg:membersadded_toaffected_emailsubject'] = 'You have been added to the audience "{$a->cohortname}"';
$string['msg:membersadded_toaffected_notice'] = 'You have been added to the audience "{$a->cohortname}"';
$string['msg:membersadded_toall_emailsubject'] = 'New members have been added to your audience "{$a->cohortname}"';
$string['msg:membersadded_toall_notice'] = '{$a->affectedcount} members have been recently added to your audience, "{$a->cohortname}"';
$string['msg:membersremoved_toaffected_emailsubject'] = 'Audience membership revoked from "{$a->cohortname}"';
$string['msg:membersremoved_toaffected_notice'] = 'You are no longer a member of the audience "{$a->cohortname}"';
$string['msg:membersremoved_toall_emailsubject'] = 'Members have left your audience "{$a->cohortname}"';
$string['msg:membersremoved_toall_notice'] = '{$a->affectedcount} members have now left your audience "{$a->cohortname}"';
$string['mustselectonecriteria'] = 'You must select at least one criterion';
$string['na'] = 'n/a';
$string['name'] = 'Audience Name';
$string['namelink'] = 'Audience Name (with link)';
$string['nocohorts'] = 'No audiences have been defined.';
$string['nocomponent'] = 'Created manually';
$string['nocriteriaset'] = '(no criteria set, delete this audience)';
$string['noenrolledlearning'] = 'No enrolled learning items for this audience.';
$string['nomembersdynamic'] = 'This audience has no members (either no users match its rules, or its member list needs to be refreshed).';
$string['nomembersstatic'] = 'This audience has no members.';
$string['noorphans'] = 'No orphaned users.';
$string['norolestoassign'] = 'No roles to assign in this context';
$string['norules'] = 'No rules have been defined for this audience.';
$string['notequalto'] = 'Not equal to';
$string['notincohort'] = 'Not in audience(s)';
$string['notvalidprofilefield'] = 'Please select a valid profile field';
$string['novisiblelearning'] = 'No visible learning';
$string['numlearners'] = '# learners';
$string['numofmembers'] = 'No. of Members';
$string['ok'] = 'Ok';
$string['or'] = 'OR';
$string['orachildof'] = '(or a child of)';
$string['orcohort'] = 'OR...';
$string['organisation'] = 'Organisation';
$string['orphanedusers'] = 'Audience "orphans"';
$string['orphanedusersreport'] = 'Audience Orphaned Users';
$string['orphaneduserssource'] = 'Audience Orphaned Users';
$string['orphanhelptext'] = 'The following users are not members of any current audience.';
$string['overview'] = 'Overview';
$string['pcdatedescafter'] = 'User completed this list of programs after {$a}:';
$string['pcdatedescbefore'] = 'User completed this list of programs before {$a}:';
$string['pcdescall'] = 'User has completed all of the programs in this list:';
$string['pcdescany'] = 'User has completed any of the programs in this list:';
$string['pcdescnotall'] = 'User has not completed all of the programs in this list:';
$string['pcdescnotany'] = 'User has not completed any of the programs in this list:';
$string['pcdurationdesclessthan'] = 'User completed this list of programs in less than {$a} day(s):';
$string['pcdurationdescmorethan'] = 'User completed this list of programs in greater than {$a} day(s):';
$string['pleaseentervaliddate'] = 'Please enter a valid date in the format dd/mm/yyyy';
$string['pleaseentervalidreason'] = 'Please enter a valid reason';
$string['pleaseentervalidunit'] = 'Please enter a valid unit between 0 and 999';
$string['pleasepickaninstance'] = 'Please choose an item';
$string['pleasesearchmore'] = 'Please refine the search';
$string['pleasesetcompletiontimes'] = 'Please set completion times for all items';
$string['pleaseusesearch'] = 'Please use the search';
$string['pluginname'] = 'Totara Audiences';
$string['position'] = 'Position';
$string['potusers'] = 'Potential users';
$string['potusersmatching'] = 'Potential matching users';
$string['proceedtochangerules'] = '<br /> Do you want to proceed? <br />';
$string['programcohortsvisible'] = 'Program audiences (visible)';
$string['querydebugheader'] = 'Query';
$string['querydebugparams'] = 'Query params';
$string['removeoldmembers']  = 'Remove a user\'s membership when they no longer meet the rule sets criteria';
$string['reportsdirectlyto'] = 'reports directly to';
$string['reportsto'] = 'reports to';
$string['role'] = 'Role';
$string['rulecheckboxdialogdesc'] = 'Add a rule based on whether {$a} is checked or not.';
$string['ruledesc-alljobassign-enddates'] = 'The end date of any of the user\'s job assignments';
$string['ruledesc-alljobassign-hasdirectreports'] = 'Whether the user is a manager in any of their job assignments.';
$string['ruledesc-alljobassign-orgid'] = 'User\'s organisation in any of their job assignments';
$string['ruledesc-alljobassign-orgidnumbers'] = 'User\'s organisation idnumber in any of their job assignments';
$string['ruledesc-alljobassign-orgnames'] = 'User\'s organisation name in any of their job assignments';
$string['ruledesc-alljobassign-orgtypes'] = 'User\'s organisation type';
$string['ruledesc-alljobassign-posassigndates'] = 'User\'s position assignment date in any of their job assignments';
$string['ruledesc-alljobassign-posid'] = 'User\'s position in any of their job assignments';
$string['ruledesc-alljobassign-posidnumbers'] = 'User\'s position idnumber in any of their job assignments';
$string['ruledesc-alljobassign-posnames'] = 'User\'s position name in any of their job assignments';
$string['ruledesc-alljobassign-postypes'] = 'User\'s position type';
$string['ruledesc-alljobassign-startdates'] = 'The start date of any of the user\'s job assignments';
$string['ruledesc-alljobassign-titles'] = 'The title of any of the user\'s job assignments';
$string['ruledesc-all'] = 'User\'s position in any of their job assignments';
$string['ruledesc-learning-coursecompletiondate'] = 'User\'s course completion date';
$string['ruledesc-learning-coursecompletionduration'] = 'User\'s course completion duration';
$string['ruledesc-learning-coursecompletionlist'] = 'User\'s course completion(s)';
$string['ruledesc-learning-programcompletiondate'] = 'User\'s program completion date';
$string['ruledesc-learning-programcompletiondurationassigned'] = 'User\'s program completion duration since assignment';
$string['ruledesc-learning-programcompletiondurationstarted'] = 'User\'s program completion duration since started';
$string['ruledesc-learning-programcompletionlist'] = 'User\'s program completion(s)';
$string['ruledesc-systemaccess-firstlogin'] = 'User\'s first login date';
$string['ruledesc-systemaccess-lastlogin'] = 'User\'s last login date';
$string['ruledesc-user-city'] = 'User\'s city';
$string['ruledesc-user-country'] = 'User\'s country';
$string['ruledesc-user-department'] = 'User\'s department';
$string['ruledesc-user-email'] = 'User\'s email address';
$string['ruledesc-user-firstname'] = 'User\'s first name';
$string['ruledesc-user-idnumber'] = 'User\'s ID number';
$string['ruledesc-user-institution'] = 'User\'s institution';
$string['ruledesc-user-lang'] = 'User\'s language preference';
$string['ruledesc-user-lastname'] = 'User\'s last name';
$string['ruledesc-user-suspendedusers'] = 'User is suspended';
$string['ruledesc-user-username'] = 'User\'s username';
$string['ruledialogdesc'] = 'Add a rule based on {$a}';
$string['ruleformat-descjoinextvars'] = '{$a->desc} {$a->join} {$a->ext} {$a->vars}';
$string['ruleformat-descjoinvars'] = '{$a->desc} {$a->join} {$a->vars}';
$string['ruleformat-descvars'] = '{$a->desc} {$a->vars}';
$string['ruleformat-framework'] = 'within the "{$a->framework}" framework';
$string['ruleformat-vars'] = '{$a->hierarchy}';
$string['rulegroup-alljobassign'] = 'All Job Assignments';
$string['rulegroup-cohort'] = 'Audience';
$string['rulegroup-learning'] = 'Learning';
$string['rulegroup-org'] = 'Organisation';
$string['rulegroup-pos'] = 'Position';
$string['rulegroup-systemaccess'] = 'System access';
$string['rulegroup-user'] = 'User profile';
$string['rulegroup-usercustomfields'] = 'User custom fields';
$string['rulehelp-job-title'] = 'Separate multiple IDs by commas e.g. "Advisor, Analyst"';
$string['rulehelp-org-idnumber'] = 'Separate multiple IDs by commas e.g. "00101,00102"';
$string['rulehelp-org-name'] = 'Separate multiple IDs by commas e.g. "Advisor, Analyst"';
$string['rulehelp-pos-idnumber'] = 'Separate multiple IDs by commas e.g. "00101, 00102"';
$string['rulehelp-pos-name'] = 'Separate multiple IDs by commas e.g. "Advisor, Analyst"';
$string['rulehelp-user-email'] = 'Separate multiple emails by commas e.g. "bob@example.com,jill@example.com"';
$string['rulehelp-user-idnumber'] = 'Separate multiple IDs by commas e.g. "001,002,003"';
$string['rulehelp-user-username'] = 'Separate multiple usernames by commas';
$string['rulelistdateformat'] = '%d %b, %Y';
$string['rulename-alljobassign-enddates'] = 'End Dates';
$string['rulename-alljobassign-hasdirectreports'] = 'Has direct reports';
$string['rulename-alljobassign-jobtitles'] = 'Titles';
$string['rulename-alljobassign-managers'] = 'Managers';
$string['rulename-alljobassign-organisations'] = 'Organisations';
$string['rulename-alljobassign-orgnames'] = 'Organisation Names';
$string['rulename-alljobassign-orgidnumbers'] = 'Organisation ID Numbers';
$string['rulename-alljobassign-orgtypes'] = 'Organisation types';
$string['rulename-alljobassign-posassigndates'] = 'Position Assignment Dates';
$string['rulename-alljobassign-posidnumbers'] = 'Position ID Numbers';
$string['rulename-alljobassign-positions'] = 'Positions';
$string['rulename-alljobassign-posnames'] = 'Position Names';
$string['rulename-alljobassign-postypes'] = 'Position types';
$string['rulename-alljobassign-startdates'] = 'Start Dates';
$string['rulename-cohort-cohortmember'] = 'Audience member';
$string['rulename-learning-coursecompletiondate'] = 'Course completion date';
$string['rulename-learning-coursecompletionduration'] = 'Course completion duration';
$string['rulename-learning-coursecompletionlist'] = 'Course completion';
$string['rulename-learning-programcompletiondate'] = 'Program completion date';
$string['rulename-learning-programcompletiondurationassigned'] = 'Program completion duration since assignment';
$string['rulename-learning-programcompletiondurationstarted'] = 'Program completion duration since started';
$string['rulename-learning-programcompletionlist'] = 'Program completion';
$string['rulename-systemaccess-firstlogin'] = 'First login date';
$string['rulename-systemaccess-lastlogin'] = 'Last login date';
$string['rulename-user-city'] = 'City';
$string['rulename-user-country'] = 'Country';
$string['rulename-user-department'] = 'Department';
$string['rulename-user-email'] = 'Email address';
$string['rulename-user-firstname'] = 'First name';
$string['rulename-user-idnumber'] = 'ID number';
$string['rulename-user-institution'] = 'Institution';
$string['rulename-user-lang'] = 'Language preference';
$string['rulename-user-lastname'] = 'Last name';
$string['rulename-user-suspendedusers'] = 'User is suspended';
$string['rulename-user-username'] = 'Username';
$string['ruleneedsnoconfiguration'] = 'This rule needs no configuration.';
$string['rules'] = 'Rules';
$string['rulesapprovesuccess'] = 'Rule changes approved';
$string['rulesapproveadhocsuccess'] = 'Rule changes approved, the audience membership is scheduled to be updated later';
$string['rulescancelsuccess'] = 'Rule changes cancelled';
$string['rulesetname'] = 'Ruleset #{$a}';
$string['rulesetoperatorlabel'] = 'Membership setting between each rule in this rule set';
$string['rulestitle'] = 'Membership criteria';
$string['rulesupdatesuccess'] = 'Rules updated';
$string['rulesupdatefailure'] = 'Failure occured while updating rules. Changes will not be applied';
$string['saveallchanges'] = 'Save all changes';
$string['saveandcreateplans'] = 'Save and create plans';
$string['saved'] = 'Settings saved';
$string['savinglearning'] = 'Saving learning...';
$string['savingrule'] = 'Saving...';
$string['selectfromcohort'] = 'Select members from audience';
$string['separatemultiplebycommas'] = 'Separate multiple values by commas';
$string['set'] = 'Set';
$string['setcompletion'] = 'Set completion';
$string['startdate'] = 'Start date';
$string['startdate_help'] = 'If a start date is provided, the audience will be treated as empty until the start date.'; // Unused.
$string['startdatelimited'] = 'Start date';
$string['startdatelimited_help'] = 'If a start date is provided:

* access to dashboards granted by this audience will not be available until this date
* if this is a dynamic audience, audience members will not be automatically updated until this date

';
$string['startswith'] = 'starts with';
$string['status'] = 'Status';
$string['successfullyaddedcohort'] = 'Successfully added audience';
$string['successfullycloned'] = 'Successfully cloned audience';
$string['successfullydeleted'] = 'Successfully deleted audience';
$string['successfullyupdated'] = 'Successfully updated audience';
$string['taskplanswillbecreated'] = 'Any learning plans will be created for audience members by an adhoc task on the next cron run. When the process completes, you will see the result in the history table.';
$string['text'] = 'Text';
$string['thiscohortwillhave'] = 'This audience will have {$a} members at this point in time';
$string['toomanyusersmatchsearch'] = 'Too many users match the search ({$a->count})';
$string['toomanyuserstoshow'] = 'There are too many users to show ({$a})';
$string['type'] = 'Type';
$string['type_help'] = '<p>The audience type can be \'set\' or \'dynamic\'.</p>
<p>Set audiences are a predefined list of users, manually created by the audience creator. The creator can add or remove users but otherwise the list is static.</p>
<p>Dynamic audiences are determined by a rule or set of rules, and the users included in the audience will dynamically update to include users who match those rules (and remove users who no longer match).</p>
<p>The members of a set audience can be changed at any time, and the rules that define a dynamic audience can also be changed, leading to the audience membership being updated.</p>';
$string['typeunknown'] = '{$a}';
$string['updatecohortstask'] = 'Sync and clean audiences';
$string['updateoperatorsbutton'] = 'Update "and/or" operators in current draft';
$string['updateroles'] = 'Assign selected role(s) to this audience';
$string['updatedrolesuccessful'] = 'Roles have been updated';
$string['updatedroleunsuccessful'] = 'There was an error while saving role(s)';
$string['useriscohortmember'] = 'User is a member of any of these audiences:';
$string['userisnotcohortmember'] = 'User is NOT a member of any of these audiences:';
$string['userprofilefield'] = 'User profile field';
$string['userreportsdirectlyto'] = 'User reports directly to any of these users:';
$string['userreportsto'] = 'User reports to any of these users:';
$string['usersorgx'] = 'User\'s organisation "{$a}"';
$string['usersposx'] = 'User\'s position "{$a}"';
$string['usersx'] = 'User\'s "{$a}"';
$string['values'] = 'Values';
$string['viewmembers'] = 'Members';
$string['visibility'] = 'Visibility';
$string['visibleall'] = 'All users';
$string['visibleaudience'] = 'Enrolled users and members of the selected audiences';
$string['visiblelearning'] = 'Visible learning';
$string['visiblelearning_help'] = 'This setting determines whether the course, program or certification appears in the corresponding list.

If "Visible to enrolled users and members of the selected audiences" is selected then it will be visible to all members of the assigned audiences.

Users that are enrolled will be able to see it, not matter what visibility setting is selected.

Users granted the \'manageaudiencevisibility\' capability (managers by default) can see all courses, programs and certifications.';
$string['visibleenrolled'] = 'Enrolled users only';
$string['visiblenousers'] = 'No users';
$string['youhaveadded'] = 'You have added {$a->itemnames} to this program<br />
<br />
<strong>This will asign {$a->affectedusers} users to the program</strong><br />
<br />
This change will be applied once the \'Save all changes\' button is clicked on the main Program assignments screen';
$string['youhaveremoved'] = 'You have removed {$a->itemname} from this program<br />
<br />
<strong>This will unasign {$a->affectedusers} users from the program</strong><br />
<br />
This change will be applied once the \'Save all changes\' button is clicked on the main Program assignments screen';

// Deprecated.
$string['ruledesc-learning-programcompletionduration'] = 'User\'s program completion duration';
$string['ruledesc-org-id'] = 'User\'s organisation';
$string['ruledesc-org-idnumber'] = 'User\'s organisation ID number';
$string['ruledesc-org-orgtype'] = 'User\'s organisation type';
$string['ruledesc-pos-hasdirectreports'] = 'User\'s direct reports';
$string['ruledesc-pos-id'] = 'User\'s position';
$string['ruledesc-pos-idnumber'] = 'User\'s position ID number';
$string['ruledesc-pos-name'] = 'User\'s position name';
$string['ruledesc-pos-postitle'] = 'User\'s position title (fullname)';
$string['ruledesc-pos-postype'] = 'User\'s position type';
$string['ruledesc-pos-startdate'] = 'User\'s position date assigned';
$string['ruledesc-pos-timevalidfrom'] = 'User\'s position start date';
$string['ruledesc-pos-timevalidto'] = 'User\'s position end date';
$string['rulename-learning-programcompletionduration'] = 'Program completion duration';
$string['rulename-org-id'] = 'Organisation';
$string['rulename-org-idnumber'] = 'Organisation ID number';
$string['rulename-org-orgtype'] = 'Organisation type';
$string['rulename-pos-hasdirectreports'] = 'Has direct reports';
$string['rulename-pos-id'] = 'Position';
$string['rulename-pos-idnumber'] = 'Position ID number';
$string['rulename-pos-name'] = 'Position name';
$string['rulename-pos-postitle'] = 'Position title (fullname)';
$string['rulename-pos-postype'] = 'Position type';
$string['rulename-pos-reportsto'] = 'Manager';
$string['rulename-pos-startdate'] = 'Position assigned date';
$string['rulename-pos-timevalidfrom'] = 'Position start date';
$string['rulename-pos-timevalidto'] = 'Position end date';
$string['rulehelp-pos-postitle'] = 'Matches against the text of the user\'s primary position title';

/*
 * @deprecated Since Totara 10.5.
 */
$string['successfullycreatedplans'] = 'Successfully created new learning plans for {$a} audience members';
