<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2015 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Brian Barnes <brian.barnes@totaralearning.com>
 * @author Joby Harding <joby.harding@totaralearning.com>
 * @package theme_basis
 */

defined('MOODLE_INTERNAL') || die;

use theme_basis\css_processor;

$component = 'theme_basis';

if ($ADMIN->fulltree) {

    // Favicon file setting.
    $name = "{$component}/favicon";
    $title = new lang_string('favicon', $component);
    $description = new lang_string('favicondesc', $component);
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'favicon', 0, array('accepted_types' => '.ico'));
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Logo file setting.
    $name = "{$component}/logo";
    $title = new lang_string('logo', $component);
    $description = new lang_string('logodesc', $component);
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'logo',0 ,['accepted_types' => 'web_image']);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Logo alt text.
    $name = "{$component}/alttext";
    $title = new lang_string('alttext', $component);
    $description = new lang_string('alttextdesc', $component);
    $setting = new admin_setting_configtext($name, $title, $description, '');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Enable / disable style overrides.
    // As settings-based style overrides are not Less processed
    // and colour variants are automatically generated by PHP
    // there is a small reduction in quality.
    $name = "{$component}/enablestyleoverrides";
    $title = new lang_string('enablestyleoverrides', $component);
    $description = new lang_string('enablestyleoverrides_desc', $component);
    $default = '0';
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Site text color
    $name = "{$component}/textcolor";
    $title = get_string('textcolor', $component);
    $description = get_string('textcolor_desc', $component);
    $default = css_processor::$DEFAULT_TEXTCOLOR;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, null, false);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Link colour setting.
    $name = "{$component}/linkcolor";
    $title = new lang_string('linkcolor', $component);
    $description = new lang_string('linkcolordesc', $component);
    $default = css_processor::$DEFAULT_LINKCOLOR;
    $previewconfig = array('selector' => 'a', 'style' => 'color');
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Link visited colour setting.
    $name = "{$component}/linkvisitedcolor";
    $title = new lang_string('linkvisitedcolor', $component);
    $description = new lang_string('linkvisitedcolordesc', $component);
    $default = css_processor::$DEFAULT_LINKVISITEDCOLOR;
    $previewconfig = array('selector' => 'a:visited', 'style' => 'color');
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Button colour setting.
    $name = "{$component}/buttoncolor";
    $title = new lang_string('buttoncolor',$component);
    $description = new lang_string('buttoncolordesc', $component);
    $default = css_processor::$DEFAULT_BUTTONCOLOR;
    $previewconfig = array('selector'=>'input[\'type=submit\']]', 'style'=>'background-color');
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Site content background color.
    $name = "{$component}/bodybackground";
    $title = get_string('bodybackground', $component);
    $description = get_string('bodybackground_desc', $component);
    $default = css_processor::$DEFAULT_BODYBACKGROUND;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, null, false);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Main content background color.
    $name = "{$component}/contentbackground";
    $title = get_string('contentbackground', $component);
    $description = get_string('contentbackground_desc', $component);
    $default = css_processor::$DEFAULT_CONTENTBACKGROUND;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, null, false);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Page header background colour setting.
    $name = "{$component}/headerbgc";
    $title = new lang_string('headerbgc', $component);
    $description = new lang_string('headerbgcdesc', $component);
    $default = css_processor::$DEFAULT_HEADERBGC;
    $previewconfig = array('selector' => '#page-header', 'style' => 'backgroundColor');
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Footnote setting.
    $name = "{$component}/footnote";
    $title = get_string('footnote', $component);
    $description = get_string('footnotedesc', $component);
    $default = '';
    $setting = new admin_setting_confightmleditor($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);

    // Custom CSS file.
    $name = "{$component}/customcss";
    $title = new lang_string('customcss',$component);
    $description = new lang_string('customcssdesc', $component);
    $setting = new admin_setting_configtextarea($name, $title, $description, '');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $settings->add($setting);
}
