<?php

// searches for admin settings

require_once('../config.php');
require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->dirroot . '/admin/admin_settings_search_form.php');

$query = trim(optional_param('query', '', PARAM_NOTAGS));  // Search string

$context = context_system::instance();
$PAGE->set_context($context);

admin_externalpage_setup('search', '', array('query' => $query)); // now hidden page
require_capability('moodle/site:config', $context); //Totara: this page is really for admins only!

$adminroot = admin_get_root(); // need all settings here
$adminroot->search = $query; // So we can reference it in search boxes later in this invocation
$statusmsg = '';
$errormsg  = '';
$focus = '';

// now we'll deal with the case that the admin has submitted the form with changed settings
if ($data = data_submitted() and confirm_sesskey() and isset($data->action) and $data->action == 'save-settings') {
    if (admin_write_settings($data)) {
        redirect($PAGE->url, get_string('changessaved'), null, \core\output\notification::NOTIFY_SUCCESS);
    }

    if (!empty($adminroot->errors)) {
        $errormsg = get_string('errorwithsettings', 'admin');
        $firsterror = reset($adminroot->errors);
        $focus = $firsterror->id;
    } else {
        redirect($PAGE->url);
    }
}

// and finally, if we get here, then there are matching settings and we have to print a form
// to modify them
echo $OUTPUT->header($focus);

echo $OUTPUT->heading(get_string('administrationsite'));

if ($errormsg !== '') {
    echo $OUTPUT->notification($errormsg);

} else if ($statusmsg !== '') {
    echo $OUTPUT->notification($statusmsg, 'notifysuccess');
}

$form = new admin_settings_search_form();
$form->display();
echo '<hr>';
if ($query) {
    echo admin_search_settings_html($query);
}

echo $OUTPUT->footer();
